<?php
/*
 * -------------------------------------------------------------
 * Demo Controller zur Veranschaulichung
 * -------------------------------------------------------------
 *
 * Controller sollten über die routes.php beim Routing aufgerufen
 * werden und steuern dann, was mit mit möglichen Daten passiert
 * und erzeugen dann eine Ausgabe als View.
 *
 *
 * METHODEN AUS DER CONTROLLER-KLASSE:
 * @method get_view( string $view_file, array $view_data )    - Rendert einen String aus einer Templatefile und einem Datensatz
 * @method render_view( string $view_file, array $view_data ) - Echo'd einen gerenderten String einer TPL-Datei und Datensatz
 *
 */

class DemoController extends Controller
{
	public function index()
	{
		/* Beispiel um mit dem Demo Model zu arbeiten */
		$demo_liste = new DemoModel();
		$demo_liste_eintraege = $demo_liste->select_all();

		/* Beispiel um den Renderer des Controllers zu nutzen */
		$view_data = [
			'headline'       => "Demo Seite",
			'copy'           => "Dies ist nur eine <strong>Demo Seite</strong>.",
			'demo_liste'     => $demo_liste_eintraege,
			'add-entry-link' => '/insert-data',
		];
		$this->render_view( 'demo', $view_data ); // 'demo' => lädt views/demo.html als Template
	}
}
