<?php
/*
 * -------------------------------------------------------------
 * Basis Controller für Grundfunktionen
 * -------------------------------------------------------------
 *
 * Stellt die Basis für alle Controller da. Im Kern ermöglicht es
 * eigentlich nur auf den Mustach Renderer zuzugreifen um Dateien
 * aus dem View-Folder zu rendern.
 *
 * Optionen zum Mustache Renderer findet man in der config.php
 *
 * METHODEN:
 * @method get_view( string $view_file, array $view_data )    - Rendert einen String aus einer Templatefile und einem Datensatz
 * @method render_view( string $view_file, array $view_data ) - Echo'd einen gerenderten String einer TPL-Datei und Datensatz
 *
 * Der Renderer ist ein Mustache PHP Renderer, Dokumentation:
 * @Link: https://github.com/bobthecow/mustache.php
 */



class Controller
{

	private $MUSTACHE = NULL;

	function __construct()
	{
		$mustache_helpers = [
			'i18n' => function($text) {
				// do something translatey here...
			}
		];
		$mustache_loader_settings = [
			'extension' => TPL_EXTENSION,
		];
		$mustache_setting = [
			'cache'                  => TPL_CACHE_DIR,
			'loader'                 => new Mustache_Loader_FilesystemLoader( VIEW_FOLDER, $mustache_loader_settings ),
			'partials_loader'        => new Mustache_Loader_FilesystemLoader( PARTIAL_FOLDER, $mustache_loader_settings ),
			'helpers'                => $mustache_helpers,
			'charset'                => 'UTF-8',
			'logger'                 => new Mustache_Logger_StreamLogger('php://stderr'),
			'strict_callables'       => true,
			'pragmas'                => [Mustache_Engine::PRAGMA_FILTERS],
		];
		$this->MUSTACHE = new Mustache_Engine( $mustache_setting );
	}

	public function get_view( $view_file, $view_data = [] )
	{
		$template = $this->MUSTACHE->loadTemplate( $view_file );
		return $template->render( $view_data );
	}

	public function render_view( $view_file, $view_data = []  )
	{
		echo $this->get_view( $view_file, $view_data );
	}

}
