<?php
/*
 * -------------------------------------------------------------
 * Demo Model zur Veranschaulichung
 * -------------------------------------------------------------
 *
 * Erweitert die Model-Klasse um die eigenen Felder & Funktionen
 * die man benötigt.
 *
 * METHODEN AUS DER MODEL-KLASSE:
 * @method get_pdo()   - Gibt das PDO zurück, um z.B. ->prepare Statements zu erzeugen
 * @method install()   - Erzeugt eine Tabelle anhand von "private $table_name" & "private $columns"
 * @method uninstall() - Löscht die Tabelle von "private $table_name"
 * @method empty()     - Leert die Tabelle unter "private $table_name"
 *
 */

class DemoModel extends Model
{

	public $table_name = "DemoData";
	public $columns    = [
		'ID'   => 'INT AUTO_INCREMENT PRIMARY KEY',
		'Name' => 'VARCHAR( 250 ) NOT NULL',
	];

	/* Demo Select */
	public function select_all()
	{
		$PDO  = $this->get_pdo();
		$stmt = $PDO->prepare( "SELECT * FROM `$this->table_name` " );
		$stmt->execute();
		return $stmt->fetchAll();
	}

	/* Demo Insert */
	public function insert( $name )
	{
		$PDO  = $this->get_pdo();
		$stmt = $PDO->prepare( "INSERT INTO `$this->table_name` (name) VALUES (:name)" );
		$stmt->bindParam( ':name', $name );
		$stmt->execute();
	}

	/* Demo Update */
	public function update( $id, $name )
	{
		$PDO  = $this->get_pdo();
		$stmt = $PDO->prepare( "UPDATE `$this->table_name` SET name=:name WHERE id=$id" );
		$stmt->bindParam( ':name', $name );
		$stmt->execute();
	}

}
