<?php
/*
 * -------------------------------------------------------------
 * Basis Model für alle "echten" eigenen Models
 * -------------------------------------------------------------
 *
 * Erzeugt ein PDO wenn mit der Datenbank verbunden wurde und
 * stellt gewisse Basis Funktionen für alle Models bereit:
 *
 * @method get_pdo()   - Gibt das PDO zurück, um z.B. ->prepare Statements zu erzeugen
 * @method install()   - Erzeugt eine Tabelle anhand von "private $table_name" & "private $columns"
 * @method uninstall() - Löscht die Tabelle von "private $table_name"
 * @method empty()     - Leert die Tabelle unter "private $table_name"
 *
 */


class Model
{
	private $PDO = null;

	/**
	 * Verbinden mit MySQL Datenbank und Rückgabe eines PDO
	 */
	public function __construct() {
		$PDO = null;
		try {
		   $PDO = new PDO( 'mysql:host='.DB_HOST.';dbname='.DB_DATABASE, DB_USERNAME, DB_PASSWORD );
		} catch (PDOException $e) {
		   print "Error!: " . $e->getMessage() . "<br/>";
		   die();
		}
        $this->PDO = $PDO;
	}

	/**
	 * Gibt ein PDO zurück für die Models später
	 * @return PDO
	 */
    public function get_pdo()
	{
		return $this->PDO;
    }

	/**
	 * Erzeugt eine Tabelle mit Spalten
	 */
	public function install()
	{
		$columns_string = $this->get_create_table_columns_string( $this->columns );
		$sql ="CREATE TABLE IF NOT EXISTS $this->table_name( $columns_string );";
		$this->PDO->exec( $sql );
	}

	/**
	 * Macht aus einem Spalten-Array einen String für das Tabellen-Create-Query
	 *
	 * z.B. [ 'id' => 'INT', ... ]  => "ID INT, ..."
	 *
	 * @param  array $columns Ein Array mit Keys als Spaltennamen und Values als deren Eigenschaften
	 */
	private function get_create_table_columns_string( $columns )
	{
		$keyless_array = [];
		foreach ( $columns as $row_name => $row_attributes ) {
			$keyless_array[] = "$row_name $row_attributes";
		}
		return implode( ',', $keyless_array );
	}

	/**
	 * Löscht eine Tabelle
	 */
	public function uninstall()
	{
		$sql ="DROP TABLE $this->table_name;";
		$this->PDO->exec( $sql );
	}

	/**
	 * Leert eine Tabelle
	 */
	public function empty()
	{
		$sql ="TRUNCATE TABLE $this->table_name;";
		$this->PDO->exec( $sql );
	}

}
