<?php
/*
 * -------------------------------------------------------------
 * Konfiguration
 * -------------------------------------------------------------
 *
 * Alle sensitiven Daten wie z.B. Datenbankpasswort sollten in
 * der .env Datei im absolutem Root angegeben sein. So das diese
 * nicht im Browser aufrufbar sind und ggf. auch für FTP User
 * versteckt sind.
 *
 */


/* === Ermöglicht .env Files zu laden === */
define( 'ENV_FOLDER', '../' );
$dotenv = Dotenv\Dotenv::createImmutable( ENV_FOLDER );
$dotenv->load();

/* === MYSQL SETTINGS === */
define( 'DB_HOST',     $_ENV['DB_HOST'] );
define( 'DB_PORT',     $_ENV['DB_PORT'] );
define( 'DB_DATABASE', $_ENV['DB_DATABASE'] );
define( 'DB_USERNAME', $_ENV['DB_USERNAME'] );
define( 'DB_PASSWORD', $_ENV['DB_PASSWORD'] );

/* === MUSTACHE TEMPLATE RENDER SETTINGS === */
define( 'VIEW_FOLDER',    dirname(__FILE__).'/views' );
define( 'PARTIAL_FOLDER', dirname(__FILE__).'/views/partials' );
define( 'TPL_CACHE_DIR',  dirname(__FILE__).'/views/.cache' );
define( 'TPL_EXTENSION',  '.html' );


/* === FLIGHT OPTIONS === */
class_alias( 'Flight', 'LISTEN' ); // Alternative Name, weil schöner
