<?php
/*
 * -------------------------------------------------------------
 * Alle Routen auf welche die App hören soll
 * -------------------------------------------------------------
 *
 * Der genutzte Router ist FlightPHP, wurde hier aber umbenannt
 * um es klarer zu machen, was diese File tut. Alle regulären
 * FlightPHP Routing Befehle funktionieren weiterhin.
 *
 * Dokumentation:
 * @link: https://flightphp.com/learn
 *
 */


/*
	Im Ideal Fall sollte hinter jeder View eine eigene
	Klasse liegen in einem s.g. Controller.

	Dieses Beispiel:
	Wenn der User auf die Index Seite '/' geht, wird die
	Methode DemoController->index() ausgeführt
 */
LISTEN::route('/', [ new DemoController(), 'index'] );



/*
	Man muss aber keine Controller nutzen, man kann auch direkt
	eine anonyme Funktion angeben und dort alle Ausgaben erzeugen
 */
LISTEN::route('/insert-data', function(){
	/* Beispiel um mit einem Model zu arbeiten */
	$demo_liste = new DemoModel();
	$demo_liste->insert( $_POST['add-name'] );
	$demo_liste->update( 1, "Bernhard" );

	/* Optional kann zum Rendern auch die Controller Klasse genutzt werden */
	$controller = new Controller();
	$view_html  = "
		Eintrag hinzugefügt und erster Eintrag geändert. <br>
		<a href=\"/\">Zurück »</a>
	";
	$view_string = $controller->get_view( 'demo-add', [ 'html' => $view_html ] );

	echo $view_string;
});



/*
	Diese bedien Funktionen dienen dazu um die Tabellen fürs
	Demo-Model zu installieren oder zu löschen
 */
LISTEN::route('/install', function(){
	$demo_liste = new DemoModel();
	$demo_liste->install();
	echo "Tabelle erzeugt </br>";
	echo "<a href=\"/\">Zurück »</a>";
});


LISTEN::route('/uninstall', function(){
	$demo_liste = new DemoModel();
	$demo_liste->uninstall();
	echo "Tabelle gelöscht </br>";
	echo "<a href=\"/\">Zurück »</a>";
});

/* === STARTET DEN ROUTER - MUSS ZUM SCHLUSS GESTARTET WERDEN === */
LISTEN::start();
