<?php
/**
 * @wordpress-plugin
 * Plugin Name:       Plugin Name
 * Plugin URI:        https://www.moewe-communication.de
 * Description:
 * Version:           1.0.0
 * Author:            Johannes Ulrich Gehrke
 * Author URI:        https://www.moewe-communication.de
 */

 namespace plugin_name;

// === File nur autorisiert aufrufen
if ( ! defined( 'WPINC' ) ) {
	die;
}

/* --------------------------------------------------------
 * (1) DEFAULTS
 * --------------------------------------------------------
 *
 * Konstanten für das Plugin die Überall verfügbar sein sollen
 *
 */
define( 'PLUGIN_NAME_VERSION', '1.0.0' );
define( 'PLUGIN_NAME_PATH',    plugin_dir_path( __FILE__ ) );
define( 'PLUGIN_NAME_URL',     plugin_dir_url( __FILE__ ) );


/* --------------------------------------------------------
 * (2) KLASSEN & FUNCTION INCLUDES
 * --------------------------------------------------------
 *
 * Funktionen und Klassen hinzufügen und verfügbar machen
 */

/* Wichtigen Basis Klassen & Abläufe */
require_once PLUGIN_NAME_PATH . 'setup/Plugin_Activator.php';

/* Admin Backend */
require_once PLUGIN_NAME_PATH . 'wp-admin/overview.php';

/* Funktionen fürs Theme */
require_once PLUGIN_NAME_PATH . 'functions/dummy_function.php';


/* --------------------------------------------------------
 * (3) PLUGIN AKTIVIERUNG
 * --------------------------------------------------------
 *
 * Statische Funktionen die ausgeführt werden, wenn das
 * Plugin aktiviert wird.
 *
 * Hauptsächlich werden hier die Datenbank-Einträge erzeugt
 *
 */
register_activation_hook( __FILE__, function(){
	\plugin_name\setup\Plugin_Activator::activate();
} );



/* --------------------------------------------------------
 * (4) PLUGIN LÄUFT / RUNTIME
 * --------------------------------------------------------
 *
 * Alles was das Plugin machen soll, wenn es aktiviert ist
 *
 */
function run_plugin(){

	/* -------------------------------------------------------- *\
	  (4.1) Settings
	\* -------------------------------------------------------- */



	/* -------------------------------------------------------- *\
	  (4.2) GLOBALS die überall verfügbar sein sollen
	\* -------------------------------------------------------- */



	/* -------------------------------------------------------- *\
	  (4.3) Alles was nur fürs Backend wichtig ist
	\* -------------------------------------------------------- */
	if ( is_admin() ){
		$wp_admin_page = new \plugin_name\admin\Overview( PLUGIN_NAME_URL );
	}


}
run_plugin();
