<?php

namespace plugin_name\admin;

/**
 *
 */
class Overview
{

	private $plugin_url    = '';

	function __construct( $plugin_url )
	{
		$this->plugin_url = $plugin_url;
		add_action( 'admin_menu', [ $this, 'add_page'] );
		add_action( 'admin_enqueue_scripts', [ $this, 'register_scripts_styles' ] );
	}

	public function add_page()
	{
		$page_title    = 'Plugin Page';
		$menu_title    = 'Plugin Page';
		$capability    = 'edit_posts';
		$menu_slug     = 'plugin-page';
		$page_function = [ $this, 'render_page'];
		$icon          = $this->plugin_url . 'assets/gfx/icon-line-chart-fill-white.png';
		$position      = 50;
		add_menu_page( $page_title, $menu_title, $capability, $menu_slug,  $page_function, $icon, $position );
	}

	public function register_scripts_styles(){
		// Style Registrieren (noch nicht einbetten)
		$handle  = 'plugin-admin-style';
		$src     = $this->plugin_url . 'assets/css/plugin_style.css';
		$deps    = [];
		$version = '1.0';
		wp_register_style( $handle, $src, $deps, $version );

		// Script Registrieren (noch nicht einbetten)
		$handle    = 'alpinejs';
		$src       = $this->plugin_url  . 'assets/js/vendor/alpine.min.js';
		$deps      = [];
		$version   = '3.2.3';
		$in_footer = false;
		wp_register_script( $handle, $src, $deps, $version,$in_footer );

	}

	public function render_page()
	{
		wp_enqueue_style( 'plugin-admin-style' );
		wp_enqueue_script( 'alpinejs' );

		/* Hier noch Logik einbauen oder so */

		include 'overview.html';
	}
}
