<?php
/**
 * Debug Helper, der eine HTML var_dump Ausgabe erzeugt
 *
 * @param  mixed   $obj   Variable für den var_dump
 * @param  boolean $title Optional. Titel über der <pre> Ausgabe
 *
 * @return void
 */
if( !function_exists('d') ){
	function d( $obj, $title = false ){
		echo "<div class=\"debug\">";
		if( $title ) {
			echo "<h3 class=\"debug__title\">" . $title . "</h3>";
		}
		echo "<pre class=\"debug__print\">";
		var_dump( $obj );
		echo "</pre>";
		echo "</div>";

		echo "
			<style type=\"text/css\">
				.debug{
					display          : block;
					margin           : 22px;
					padding          : 11px;
					max-width        : calc( 100% - 44px );
					background-color : rgb(255 245 225);
					border-left      : 11px solid rgb(255,200,0);
				}
				.debug__title{
					margin      : 0px 0px 22px 0px;
					font-family : -apple-system, BlinkMacSystemFont, avenir next, avenir, segoe ui, helvetica neue, helvetica, Ubuntu, roboto, noto, arial, sans-serif;
					font-weight : 600;
					font-size   : 18px;
					line-height : 22px;
					color       : rgb(255,200,0);
					text-shadow : 1px 1px 2px rgba(125,100,0,0.3);
				}
				.debug__print{
					margin      : 0px;
					padding     : 0px;
					font-family : Menlo, Consolas, Monaco, Liberation Mono, Lucida Console, monospace;
					color       : rgb(90,90,90);
					font-size   : 12px;
					line-height : 22px;
				}
			</style>
		";
	};
}
