<?php

namespace plugin_name\wp_admin;

/*
	SEITE EINKLINGEN
 */
new PageName( PLUGIN_NAME_URL );

/**
 * SEITEN EIGENSCHAFTEN
 */
class PageName
{

	private $plugin_url    = '';

	function __construct( $plugin_url )
	{
		if ( !is_admin() ){ return; }
		$this->plugin_url = $plugin_url;
		add_action( 'admin_menu', [ $this, 'add_page'] );
		add_action( 'admin_enqueue_scripts', [ $this, 'register_scripts_styles' ] );
	}

	public function add_page()
	{
		$page_title    = 'Page Name';
		$menu_title    = 'Page Name';
		$capability    = 'edit_posts';
		$menu_slug     = 'page-name';
		$page_function = [ $this, 'render_page'];
		$icon          = $this->plugin_url . 'assets/gfx/icon-send-white.png';
		$position      = 50;
		add_menu_page( $page_title, $menu_title, $capability, $menu_slug,  $page_function, $icon, $position );
	}

	public function register_scripts_styles(){
		// @see setup/admin_css_js.php
	}

	public function render_page()
	{
		// @see setup/admin_css_js.php
		wp_enqueue_script( 'alpine-js' );

		include 'PageName.html';
	}
}
