<?php
/**
 * @wordpress-plugin
 * Plugin Name:       Plugin Name
 * Plugin URI:        https://www.
 * Description:
 * Version:           0.0.1
 * Author:            
 * Author URI:        https://www.
 */

namespace plugin_name;

// === File nur autorisiert aufrufen
if ( ! defined( 'WPINC' ) ) {
	die;
}

/* --------------------------------------------------------
 * (1) DEFAULTS
 * --------------------------------------------------------
 *
 * Konstanten für das Plugin die Überall verfügbar sein sollen
 *
 */
define( 'PLUGIN_NAME_NAME',       'Plugin Name' );
define( 'PLUGIN_NAME_VERSION',    '1.0.0' );
define( 'PLUGIN_NAME_PATH',       plugin_dir_path( __FILE__ ) );
define( 'PLUGIN_NAME_URL',        plugin_dir_url( __FILE__ ) );
define( 'PLUGIN_NAME_TXT_DOMAIN', 'plugin_name_textdomain' );



/* --------------------------------------------------------
 * (2) PLUGIN AKTIVIERUNG
 * --------------------------------------------------------
 *
 * Funktionen die ausgeführt werden sollen, wenn das Plugin
 * aktiviert wird. z.B. Datenbanken erstellen oder ähnliches.
 *
 */
register_activation_hook( __FILE__, function(){
	/* Hier Code der bei Aktivierung ausgeführt werden sollen */
	// Bsp.:
	// require_once 'PluginActivator.php';
	// PluginActivator::activate();
} );



/* --------------------------------------------------------
 * (3) PLUGIN CALL
 * --------------------------------------------------------
 *
 * Plugin erst ausführen, wenn alle Plugins geladen sind
 *
 */
add_action( 'plugins_loaded', 'plugin_name\run_plugin' );



/* --------------------------------------------------------
 * (4) PLUGIN LÄUFT / RUNTIME
 * --------------------------------------------------------
 *
 * Alles was das Plugin machen soll, wenn es aktiviert ist.
 * Hier können noch Sicherheitskontrollen eingebaut werden,
 * z.B. prüfen ob ein benötigtest Plugin aktiv ist oder nicht
 *
 */
function run_plugin(){

	init_plugin();

}



/* --------------------------------------------------------
 * (5) MASTER INIT FUNCTION FOR RUNTIME
 * --------------------------------------------------------
 *
 * Was alles passieren soll, wenn das Plugin gestartet wird
 * und ohne eingrenzung einfach laufen soll
 *
 */
function init_plugin(){


	/* --------------------------------------------------------
	 * (5.1) CLASSES & FUNCTIONS INCLUDES
	 * --------------------------------------------------------
	 *
	 * Funktionen und Klassen hinzufügen und verfügbar machen,
	 * die neue Funktionen im Rahmen des Plugins hinzfügen
	 */

	/* HELPER */
	require_once PLUGIN_NAME_PATH . 'functions/helper/d.php';
	require_once PLUGIN_NAME_PATH . 'functions/helper/require_all_plugin_files.php';

	/* Allgemeine Funktionen */
	require_all_plugin_files( PLUGIN_NAME_PATH, 'functions/' );

	/* Klassen für innerhalb des Plugins */
	require_all_plugin_files( PLUGIN_NAME_PATH, 'classes/' );


	/* --------------------------------------------------------
	 * (5.2) SETUP & GENERALS INCLUDES
	 * --------------------------------------------------------
	 *
	 * Alles was dann im WP Direkt auftaucht oder angewendet
	 * kannd, also Dinge wie Shortcodes, Post Types, etc.
	 */

	/* HOOKS'n'STUFF */
	require_all_plugin_files( PLUGIN_NAME_PATH, 'setup/' );

	/*  BACKEND PAGES */
	require_all_plugin_files( PLUGIN_NAME_PATH, 'wp-admin/' );
}


/* --------------------------------------------------------
 * (6) INDEPENDET FUNCTIONS
 * --------------------------------------------------------
 *
 * Funktionen die außerhalb des init() verfügbar sein sollen
 *
 */

//

