<?php


/**
 * VIEW
 *
 * Befüllt ein HTML Template mit Daten und gibt es zurück
 *
 * USAGE:
 * View::config( [] ) - Konfigurieren
 * View::get( string $Template, array $Data ) - gibt einen Inhalt als String zurück
 * View::render( string $Template, array $Data ) - gibt einen Inhalt aus ( echo )
 *
 * View::add( string $template, array $Data ) - Füg ein Element der Liste internen Liste hinzu
 *
 * Statt $template kann auch ein Array übergeben werden:
 * 	$element = [
 * 		'template/path' => [
 * 			'data_1' => '...',
 * 			'data_2' => '...',
 * 		]
 * 	];
 * 	Render:view( $element );
 *
 */
class View
{
	private static $renderer = NULL;
	private static $element_list = [];

	public static function config( $config = [] )
	{
		new self();
		$settings = array_merge(
			[
				'path'       => '/',
				'extenstion' => 'html',
				'helpers'    => [],
			],
			$config
		);
		$engine_options = [
		    'loader'          => new Mustache_Loader_FilesystemLoader( $settings['path'],  ['extension' => $settings['extenstion'] ] ),
		    'helpers'         => $settings['helpers'],
		    'charset'         => 'UTF-8',
		];
		self::$renderer = new Mustache_Engine( $engine_options );
	}

	public static function add( $element, $view_data = [] )
	{
		self::$element_list[] = [
				'template'  => $element,
				'view_data' => $view_data,
			];
	}



	public static function render( $element = false, $view_data = [] )
	{
		echo self::get_html( $element, $view_data );
	}

	public static function get_html( $element = false, $view_data = [] )
	{
		$render_function = ( $element ) ? 'get_single' : 'get_all_from_list';
		return self::$render_function( $element, $view_data );
	}

	private static function get_all_from_list()
	{
		$html = "";
		foreach ( self::$element_list as $element_key => $element_data ) {
			$html .= self::get_single( $element_data['template'], $element_data['view_data'] );
		}
		return $html;
	}

	private static function get_single( $template, $view_data  )
	{
		return self::$renderer->render( $template, $view_data );
	}

}
