<?php

/**
 * Require_once für alle Files in einem Theme Folder.
 * Z.b. THEME/functions/*.php
 *
 * @param  string $folder   Directory aus dem Includiert werden soll, z.B. "functions/"
 * @param  string $suffix   Optional.  Auf was die Dateien enden müssen. Default: '.php'
 *
 */
function require_all_files( $folder = 'functions/', $suffix = '.php' ){
	$search_path = get_template_directory() . '/' . $folder . '*' . $suffix;

	foreach( glob( $search_path ) as $file ) {
	    require_once $file;
	}

}
