<?php
namespace theme\functions\theme_setup;


function add_image_sizes() {
    add_image_size( 'facebook_article', 1200,  630, ['center', 'center']  );
    add_image_size( 'instagram_post',   1080, 1080, ['center', 'center']  );
    add_image_size( 'twitter_image',    1024,  512, ['center', 'center']  );
    add_image_size( 'full_hd',          1920, 1080, ['center', 'center']  );
}
add_action( 'after_setup_theme', 'theme\functions\theme_setup\add_image_sizes' );




function image_sizes_admin_names( $sizes ) {
    return array_merge( $sizes, array(
        'facebook_article' => __( 'Facebook Article (1200x630)' ),
        'instagram_post'   => __( 'Instagram Post (1080x1080)' ),
        'twitter_image'    => __( 'Twitter Image (1024x512)' ),
        'full_hd'          => __( 'Full HD (1920x1080)' ),
    ) );
}
add_filter( 'image_size_names_choose', 'theme\functions\theme_setup\image_sizes_admin_names' );
