<?php
namespace theme\functions\theme_setup;

/*
	Doku : https://developer.wordpress.org/reference/functions/add_theme_support/

	Enthält Farben-Presets für Gutenberg
 */

function gutenberg_theme_support(){
	/*
		Gutenberg Supports
	 */
	add_theme_support( 'wp-block-styles' );
	add_theme_support( 'align-wide' );
	add_theme_support( 'responsive-embeds' );
	add_theme_support( 'custom-spacing' );
	add_theme_support( 'custom-line-height' );

	$editor_font_sizes = [
		[
			'name' => esc_attr__( 'Small', 'theme2022' ),
			'size' => 12,
			'slug' => 'small'
		],
		[
			'name' => esc_attr__( 'Regular', 'theme2022' ),
			'size' => 16,
			'slug' => 'regular'
		],
	];
	add_theme_support( 'editor-font-sizes', $editor_font_sizes );

	$editor_color_palette = [ /* COLOR PRESETS for Gutenberg */
		[
			'name'  => esc_attr__( 'very light gray', 'theme2022' ),
	        'slug'  => 'white',
	        'color' => '#ffffff',
		],
		[
			'name'  => esc_attr__( 'very light gray', 'theme2022' ),
	        'slug'  => 'very-light-gray',
	        'color' => '#eee',
		],
		[
			'name'  => esc_attr__( 'very dark gray', 'theme2022' ),
	        'slug'  => 'very-dark-gray',
	        'color' => '#444',
		],
		[
	        'name'  => esc_attr__( 'strong magenta', 'theme2022' ),
	        'slug'  => 'brandgrad-black',
	        'color' => '#001e32',
		],
		[
	        'name'  => esc_attr__( 'strong magenta', 'theme2022' ),
	        'slug'  => 'brandgrad-red',
	        'color' => '#e62814',
		],
	];
	add_theme_support( 'editor-color-palette', $editor_color_palette );

	$editor_gradient_palette = [ /* Gradient PRESETS for Gutenberg */
		[
			'name'     => esc_attr__( 'Vivid cyan blue to vivid purple', 'brandgrad2021' ),
			'gradient' => 'linear-gradient(135deg,rgba(6,147,227,1) 0%,rgb(155,81,224) 100%)',
			'slug'     => 'vivid-cyan-blue-to-vivid-purple'
		],
		[
			'name'     => esc_attr__( 'Vivid green cyan to vivid cyan blue', 'brandgrad2021' ),
			'gradient' => 'linear-gradient(135deg,rgba(0,208,132,1) 0%,rgba(6,147,227,1) 100%)',
			'slug'     =>  'vivid-green-cyan-to-vivid-cyan-blue',
		],
	];
	add_theme_support( 'editor-gradient-presets', $editor_gradient_palette );
}

add_action('after_setup_theme','theme\functions\theme_setup\gutenberg_theme_support');
