<?php
namespace theme\template_parts\blocks_elementor;


/**----------------------------------------------------
 *  Eigene Elementor Gruppe erstellen
 * ----------------------------------------------------
 * 
 * Dokumentation
 * @link https://developers.elementor.com/docs/context-menu/add-new-group/
 * 
 */
add_action( 'elementor/elements/categories_registered', 'theme\template_parts\blocks_elementor\add_elementor_widget_categories' );
function add_elementor_widget_categories( $elements_manager ) {
	$categories = [];
    $categories['theme'] = [
		'title' => 'Theme Blocks',
		'icon'  => 'fa fa-solid fa-fire'
    ];

	/* Sortieren, damit unsere neue Kategorie als erstes gelistet wird */
    $old_categories = $elements_manager->get_categories();
    $categories     = array_merge( $categories, $old_categories );

    $set_categories = function ( $categories ) {
        $this->categories = $categories;
    };

    $set_categories->call( $elements_manager, $categories );
}