<?php
/* --------------------------------------------- *\

   SETUP HINWEISE ZUR EINRICHTUNG

   (1) Required Plugins definieren unter:
       » function/tgm-plugin-activation/theme-plugins.php
	   (
	    ggf. auch die Plugin-Zip Dateien löschen aus dem Folder:
		» function/tgm-plugin-activation/plugins/...
	   )
   
   (2) Theme Setup Files einrichten unter:
       » functions/theme-setup/ ...
	   (
	    Hier sind verschiedene Standard Setups, wie 
	    Bildgrößen, Theme-Support, CSS-&JS-Enques, etc...
	   )

   (3) Optional: Mustache konfigurieren unter:
       » functions/_mustache-template-engine.php 

   (4) Optionale Folder/Funktionen entfernen:
       » functions/post-types            - falls keine Post-Klassen nutzen möchtest
	   » template-parts/blocks-elementor - falls keine Elementor Blocks nutzen möchtest
	   » html/block-elementor            - falls keine Elementor Blocks nutzen möchtest

\* --------------------------------------------- */


/* ******************* *\
 *
 *  CONFIG CONSTANTS
 *
\* ******************* */

define( 'THEME_DIR', get_stylesheet_directory() );
define( 'THEME_URL', get_stylesheet_directory_uri() . '/' );

/* ******************* *\
 *
 *  VENDOR / COMPOSER
 *
\* ******************* */
require_once 'vendor/autoload.php';



/* ******************* *\
 *
 *        HELPER
 *
\* ******************* */
require_once 'functions/_d.php';
require_once 'functions/_require_all_files.php';



/* ******************* *\
 *
 *    PLUGIN MANAGER
 *
\* ******************* */
require_once 'functions/tgm-plugin-activation/theme-plugins.php';



/* ******************* *\
 *
 *     THEME SETUP
 *
\* ******************* */

// Hier sind alle Files drin, wie theme_support, styles, scripts & menus
require_all_files( 'functions/theme-setup/' );



/* ******************* *\
 *
 *    GENERAL FUNCTIONS
 *
\* ******************* */

// Hier allgemeine Funktionen drin, die Files heißen
// wie die Funktion die man in Ihr findet
require_all_files( 'functions/' );
require_all_files( 'functions/post-types/' ); // -- Classes für Custom Post Types

// Elementor Blocks liegen hier
// require_all_files( 'template-parts/blocks-elementor/' );         // -- Gruppe anlegen und Blöcke registrieren
// require_all_files( 'template-parts/blocks-elementor/blocks/' );  // -- Einzelnen Blöcke