<?php
/**
 * Gibt ein gerendertes Template/Module zurück oder aus 
 *
 * Beispiele:
 *   // Ausgabe der html/header.html Datei
 *   render( 'header' );                  
 * 
 *   // Ausgabe der html/header.html Datei mit eigenen Variablen
 *   render( 'header', [ headline => 'Meine Headline' ] ) 
 * 
 *   // Rückgabe der html/header.html Datei mit eigenen Variablen als String
 *   $header_html = render( 'header', [ headline => 'Meine Headline' ], false );
 * 
 * 
 * 
 * @param string  $tpl_name    Pfad zur HTML-Datei laut der Konfigration. z.B.: 'header' würde 'theme/html/header.html' öffnen 
 * @param array   $tpl_values  Template-Variablen, z.B.: [ headline => 'Meine Super Headline' ]
 * @param boolean $echo        Optional, ob das Render ausgegeben werden soll (default), oder es als Return-String zurück gegeben wird        
 * 
 * @return void|string
 */ 
function render( string $tpl_name, array $tpl_values = [], bool $echo = true ){
	global $MUSTACHE;

	$tpl_parsed = $MUSTACHE->loadTemplate( $tpl_name ); 
	$html       = $tpl_parsed->render( $tpl_values );

	if( $echo ){
		echo $html;
	}else{
		return $html;
	}
}
