<?php 
namespace theme\functions\post_types;
use theme\functions\post_types\Page as Page;
use WP_Query;

final class Pages
{
	public static function get_all():array
	{
		$wp_query_args = [
			'post_type'      => ['page'],
			'posts_per_page' => -1,
		];
		$wp_query  = new WP_Query();
		$results   = $wp_query->query( $wp_query_args );

		$has_results = ( count( $results ) > 0 ) ? true : false;
		if( !$has_results ){ return []; }

		$pages = [];
		foreach( $results as $key => $wp_post ) {
			$pages[] = new Page( $wp_post->ID );
		}

		return $pages;
	}
}
