<?php 
namespace theme\functions\post_types;
use theme\functions\theme_setup\metaboxes\AdditionalPostInfos;
use WP_Post;
use DateTime;

final class Post
{
	public $ID                 = '';
	public $title              = '';
	public $title_short        = '';
	public $excerpt            = '';
	public $content            = '';
	public $permalink          = '';
	public $date               = '';
	public $date_formatted     = '';
	public $thumbnail          = '';
	public $thumbnail_fullsize = '';
	public $categories         = [
		'ids'   => [],
		'names' => [],
		'slugs' => [],
	];

	public $is_highlight         = null;
	public $metabox_description  = '';
	public $css_classes          = [];

	private $thumbnail_size = 'medium_large'; // thumbnail, medium, medium_large, large, full
	private $fullsize_size  = 'full'; // thumbnail, medium, medium_large, large, full

	function __construct( int $wp_post_id )
	{
		$wp_post = get_post( $wp_post_id );

		$this->set_id( $wp_post );
		$this->set_title( $wp_post );
		$this->set_permalink( $wp_post );
		$this->set_date( $wp_post );
		$this->set_content( $wp_post );
		$this->set_thumbnail( $wp_post );
		$this->set_thumbnail_fullsize( $wp_post );
		$this->set_categories( $wp_post );

		// --- Dinge die ACF brauchen oder auf Metabox Daten zurück greifen
		$this->set_date_formatted( $this->date );

	}

	private function set_id( WP_Post $wp_post ){ $this->ID = $wp_post->ID; }
	private function set_title( WP_Post $wp_post ){ $this->title = $wp_post->post_title; }
	private function set_permalink( WP_Post $wp_post ){ $this->permalink = get_the_permalink( $wp_post->ID ); }
	private function set_date( WP_Post $wp_post ){ $this->date = $wp_post->post_date; }


	/**
	 * Content setzen
	 * 
	 * wichtig ist hier der filter 'the_content'. Die Funktion basiert 
	 * stark auf der WP Funktion 'the_content'
	 * @link https://developer.wordpress.org/reference/functions/the_content/
	 *
	 * @param WP_Post $wp_post
	 * @return void
	 */
	private function set_content( WP_Post $wp_post )
	{ 
		$filtered_content = $wp_post->post_content;
		$filtered_content = apply_filters( 'the_content', $filtered_content );
		$filtered_content = str_replace( ']]>', ']]&gt;', $filtered_content );

		$this->content    = $filtered_content;
	}



	private function set_thumbnail( WP_Post $wp_post )
	{
		$thumbnail_size  = $this->thumbnail_size;
		$thumnail_url    = get_the_post_thumbnail_url( $wp_post->ID, $thumbnail_size );
		$this->thumbnail = $thumnail_url;
	}



	private function set_thumbnail_fullsize( WP_Post $wp_post )
	{
		$thumbnail_size           = $this->fullsize_size;
		$thumnail_url             = get_the_post_thumbnail_url( $wp_post->ID, $thumbnail_size );
		$this->thumbnail_fullsize = $thumnail_url;
	}



	private function set_categories( WP_Post $wp_post )
	{
		$categories = get_the_category( $wp_post->ID ); // Array mit WP_Term Objekten
		
		foreach( $categories as $key => $category ) {
			$this->categories['ids'][]   = $category->term_id;
			$this->categories['names'][] = $category->name;
			$this->categories['slugs'][] = $category->slug;
		}
	}



	private function set_date_formatted( string $date_string )
	{
		$post_datetime   = new DateTime( $date_string );
		$acf_date_format = 'd.m.Y H:i';
		$formatted_date  = $post_datetime->format( $acf_date_format ); 

		$this->date_formatted = $formatted_date;
	}

}
