<?php 
namespace theme\functions\post_types;
use theme\functions\post_types\Post as Post;
use WP_Query;

final class Posts
{
	public static function get_all( array $additional_args = [] ):array
	{
		$wp_query_args = [
			'post_type'      => ['post'],
			'posts_per_page' => -1,
		];
		$wp_query_args = array_merge( $wp_query_args, $additional_args );

		$wp_query      = new WP_Query();
		$results       = $wp_query->query( $wp_query_args );

		$has_results = ( count( $results ) > 0 ) ? true : false;
		if( !$has_results ){ return []; }

		$posts = [];
		foreach( $results as $key => $wp_post ) {
			$posts[] = new Post( $wp_post->ID );
		}

		return $posts;
	}


	public static function get_paged( int|string $page = 1, int|string $posts_per_page = -1, array $additional_args = [] )
	{
		$wp_query_args = [
			'post_type'      => ['post'],
			'posts_per_page' => $posts_per_page,
			'paged'          => $page
		];
		$wp_query_args = array_merge( $wp_query_args, $additional_args );

		$wp_query      = new WP_Query();
		$results       = $wp_query->query( $wp_query_args );

		$has_results = ( count( $results ) > 0 ) ? true : false;
		if( !$has_results ){ return []; }

		$posts = [];
		foreach( $results as $key => $wp_post ) {
			$posts[] = new Post( $wp_post->ID );
		}

		return $posts;
	}


	public static function get_from_categories( array $category_ids = [], int $posts_per_page = -1 ):array 
	{
		// Default Query Args zum Übergeben
		$query_arg = [
			'posts_per_page' => $posts_per_page,
		];

		// Kontrolle welche Seite gezeigt werden soll
		if( isset( $_GET['seite'] ) ) {
			$query_arg['paged'] = (int) $_GET['seite'];
		}
	
		// Kontrolle welche Kategorien gezeigt werden sollen
		if( !empty( $category_ids ) ){
			$query_arg['category__in'] = $category_ids;
		};

		return self::get_all( $query_arg );
	}
}
