<?php
namespace theme\functions\theme_setup;


/**
 * Verlinkt die style-editor.css in den TinyMCE
 */
add_action( 'admin_init', 'theme\functions\theme_setup\add_editor_styles' );
function add_editor_styles() {
    add_editor_style( 'style-editor.css' );
}


/**
 * Erzeugt den "Format" Selector Button
 */
add_filter( 'mce_buttons_2', 'theme\functions\theme_setup\add_format_button' );
function add_format_button( $buttons ) {
	array_unshift( $buttons, 'styleselect' );
	return $buttons;
}



/**
 * Eigene Styles auswählbar machen
 * @link https://codex.wordpress.org/TinyMCE_Custom_Styles
 */
add_filter( 'tiny_mce_before_init', 'theme\functions\theme_setup\add_styles' );  
function add_styles( $init_array ) {  

	$font_color_red = [ // Bsp.: Ein ausgewählter Text-Abschnitt, bekommt ein zusätzliches <span>-Element mit der Klasse "font-color-red"
		'title'   => 'Font Color: Red',  
		'inline'  => 'span',  
		'classes' => 'font-color-red',
		'wrapper' => true,
	];
	$button_red = [ // Bsp.: Ein ausgwähltes <a>-Tag bekommt die Klassen: "button button-red"
		'title'    => 'Button: Red',  
		'selector' => 'a',  
		'classes'  => 'button button-red',
		'wrapper'  => false,
	];

	// -- Styles zusammenführen
	$style_formats = [
		$font_color_red,
		$button_red,
	] ;

	$init_array['style_formats'] = wp_json_encode( $style_formats );  
	
	return $init_array;  
  
} 

