<?php
/*
 WP-DASHBOARD API DOKU
 @link : https://developer.wordpress.org/apis/dashboard-widgets/

*/
namespace theme\functions\theme_setup;

add_action( 'wp_dashboard_setup', 'theme\functions\theme_setup\add_dashboard_widget' );
function add_dashboard_widget() {
	$website_title    = get_bloginfo( 'name' );

	$widget_id        = 'dashboard_widget';
	$widget_name      = $website_title;
	$render_callback  = 'theme\functions\theme_setup\dashboard_widget_function';
	$control_callback = null;
	$callback_args    = [];
	$context          = 'normal';  // 'normal', 'side', 'column3', or 'column4'. Default 'normal'
	$priority         = 'high' ;   // 'high', 'core', 'default', or 'low'. Default 'core'
	
	wp_add_dashboard_widget( $widget_id, $widget_name, $render_callback );
}

function dashboard_widget_function( $post, $callback_args ) {
	$theme_preview_img_url = THEME_URL . "screenshot.png";
	echo "
		<img src=\"{$theme_preview_img_url}\" style=\"max-width : 100%\"/>
	";
}
