<?php
namespace theme\template_parts\blocks_elementor;

class SingleImage extends \Elementor\Widget_Base {

	public function get_name()       { return 'mhb_single_image'; }
	public function get_title()      { return 'Single Image'; }
	public function get_icon()       { return 'eicon-image'; } // @see https://elementor.github.io/elementor-icons/
	public function get_categories() { return [ 'theme' ]; }
	public function get_keywords()   { return [ 'theme', 'image' ]; }

	public function get_script_depends() { return []; } // [ 'widget-script-1', 'widget-script-2' ]
	public function get_style_depends()  { return []; }
	
	protected function is_dynamic_content():bool { return false; }

	/**
	 * Eingabe Möglichkeiten
	 * 
	 * Verfügbare Control Types
	 * @link https://developers.elementor.com/docs/editor-controls/control-types/
	 * 
	 * @return void
	 */
	protected function register_controls() {

		/* --- Section :: Column Left --- */
		$this->start_controls_section(
			'section_image',
			[
				'label' => 'Image',
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'image',
			[
				'label' => 'Choose Image',
				'type'  => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);


		$this->end_controls_section();

		/* --- Section :: Styling --- */
		$this->start_controls_section(
			'section_styling',
			[
				'label' => 'Styling',
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'padding_top_bottom_class',
			[
				'label'   => 'Background Color',
				'type'    => \Elementor\Controls_Manager::SELECT,
				'default' => '',
				'options' => [
					''                        => 'Default',
					'padding-top-bottom-none' => 'None',
				],
			]
		);

		$this->add_control(
			'background_color_class',
			[
				'label'   => 'Background Color',
				'type'    => \Elementor\Controls_Manager::SELECT,
				'default' => 'background-white',
				'options' => [
					'background-white'      => 'White',
					'background-gray-light' => 'Gray (light)',
					'background-black'      => 'Black',
				],
			]
		);

		$this->end_controls_section();

	}

	/**
	 * Renderer
	 *
	 * @return void
	 */
	protected function render() {

		$tpl_values  = $this->get_settings_for_display();
		$tpl_name    = 'elementor-blocks/SingleImage';

		render( $tpl_name, $tpl_values );
	}
}