<?php
namespace theme\template_parts\blocks_elementor;

class TextColumns extends \Elementor\Widget_Base {

	public function get_name()       { return 'mhb_text_columns'; }
	public function get_title()      { return 'Text Columns'; }
	public function get_icon()       { return 'eicon-columns'; } // @see https://elementor.github.io/elementor-icons/
	public function get_categories() { return [ 'theme' ]; }
	public function get_keywords()   { return [ 'theme', 'text' ]; }

	public function get_script_depends() { return []; } // [ 'widget-script-1', 'widget-script-2' ]
	public function get_style_depends()  { return []; }
	
	protected function is_dynamic_content():bool { return false; }

	/**
	 * Eingabe Möglichkeiten
	 * 
	 * Verfügbare Control Types
	 * @link https://developers.elementor.com/docs/editor-controls/control-types/
	 * 
	 * @return void
	 */
	protected function register_controls() {

		/* --- Section :: Column Left --- */
		$this->start_controls_section(
			'section_column_left',
			[
				'label' => 'Column Left',
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'text_left',
			[
				'label'       => 'Text',
				'type'        => \Elementor\Controls_Manager::WYSIWYG,
				'default'     => '',
				'placeholder' => 'Some Title or Copy...',
			]
		);


		$this->end_controls_section();

		/* --- Section :: Column Right --- */
		$this->start_controls_section(
			'section_column_right',
			[
				'label' => 'Column Right',
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'text_right',
			[
				'label'       => 'Text',
				'type'        => \Elementor\Controls_Manager::WYSIWYG,
				'default'     => '',
				'placeholder' => 'Some Title or Copy...',
			]
		);

		$this->end_controls_section();

		/* --- Section :: Styling --- */
		$this->start_controls_section(
			'section_styling',
			[
				'label' => 'Styling',
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'padding_top_bottom_class',
			[
				'label'   => 'Top & Bottom Spacing',
				'type'    => \Elementor\Controls_Manager::SELECT,
				'default' => 'background-white',
				'options' => [
					''                    => 'Default',
					'padding-top-none'    => 'No Top-Spacing',
					'padding-bottom-none' => 'No Bottom-Spacing',
					'padding-both-none'   => 'No Spacing',
				],
				'default' => '',
			]
		);

		$this->add_control(
			'background_color_class',
			[
				'label'   => 'Background Color',
				'type'    => \Elementor\Controls_Manager::SELECT,
				'default' => 'background-white',
				'options' => [
					'background-white'      => 'White',
					'background-gray-light' => 'Gray (light)',
					'background-black'      => 'Black',
				],
			]
		);

		$this->end_controls_section();

	}

	/**
	 * Renderer
	 *
	 * @return void
	 */
	protected function render() {

		$tpl_values  = $this->get_settings_for_display();
		$tpl_name    = 'elementor-blocks/TextColumns';

		render( $tpl_name, $tpl_values );
	}
}